#!/usr/bin/python
import sys
import os
import signal
import time

try:
    from pygpibtoolkit.gpibcontroller import GPIBController
except ImportError:
    sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), ".."))
    from pygpibtoolkit.gpibcontroller import GPIBController
import pygpibtoolkit.HP3562A
import pygpibtoolkit.HP3456
import pygpibtoolkit.HP8904
from pygpibtoolkit.prologix import GPIB


import optparse
opt = optparse.OptionParser("A simple tool for detecting connected GPIB devices")
opt.add_option('-d', '--device', default="/dev/ttyUSB0",
               dest="device",
               help="Device of connected Prologix GPIB bundle [/dev/ttyUSB0]",)
options, argv = opt.parse_args(sys.argv)

cnx = GPIB(device=options.device)
c = GPIBController(cnx)


    
