# -*- coding: utf-8 -*-
import numpy
import pylab

from hpgl_parser import HPGLParser

class HPGLmplPlotter(HPGLParser):
    pens = "krbgcmyw"
    lines = ['-', ':', '--', '-.', '.', '-', '-', '-']
    def __init__(self, data):        
        super(HPGLmplPlotter, self).__init__(data)
        pylab.show()
        
    def plot_symbols(self, points):
        x, y = points.T
        pylab.plot(x, y, 'o')

    def plot_lines(self, points):
        x, y = points.T
        pylab.plot(x, y, self.pens[self.pen]+self.lines[self.line_type])
        
if __name__ == "__main__":
    import sys
    data = open(sys.argv[1]).read()
    HPGLmplPlotter(data)
    
