"""
gpib: create serial connection to GPIB-USB device (ProLogix is the
only supported device for now).
"""
import serial
from serial.serialutil import SerialException
import time

class ConnectionError(Exception):
    pass

class Constants(object):
    def __init__(self):
        self.constants = {}
        self.descriptions = {}
        self.rev_constants = {}
        for v, k, m in self._constants:
            self.k = v
            self.constants[v] = k
            self.rev_constants[k] = v
            self.descriptions[v] = m
            
    def __getitem__(self, k):
        if isinstance(k, basestring):
            return self.rev_constants[k]
        else:
            return self.constants[k]

    def get_description(self, k):
        if isinstance(k, basestring):
            k = self.rev_constants[k]
        return self.descriptions[k]
    

class MODE(Constants):    
    _constants = [(1, "CONTROLLER", "Set device as Controller in Charge"),
                  (0, "DEVICE", "Set device as simple listener"),
                  ]
# TODO
# class STATUS_BYTE(Constants):
#     # IEEE 488.2 Status Byte constants
#     MAV = 0x10 # Message AVailable: bit 4 of the Status Byte
#     ESB = 0x20 # Event Status Bit: bit 5 of the Status Byte
#     MSS = 0x40 # Master Summary Status bit: bit 6 of the Status Byte (NOT
#                # sent in response to a serial poll)
#     RQS = 0x40 # Request Service: bit 6 of the Status Byte (when sent in
#                # response to a serial poll)
# class SESR(Constants):
#     # SESR constants (Standard Event Status Register)
#     PON = 0x80 # Power On: Power has been turned On since last register
#                # read access
#     URQ = 0x40 # User Request: the user has activated some device control
#                # (whatever the Remote Local state is)
#     CME = 0x20 # Command Error
#     EXE = 0x10 # Execution Error
#     DDE = 0x08 # Device Dependant Error
#     QYE = 0x04 # QuerY Error (attempt to read data while Output Queue is
#                # empty, or data in the OQ was lost)
#     RQC = 0x02 # Request Control: tell the CiC that the device wants to
#                # become the CiC
#     OPC = 0x01 # Operation Complete: device has completed any pending
#                # operation (ready to accept new commands). This bit is
#                # generated in response to a OPC command.
    
