# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
""" Copyright (c) 2007-2018 David Douard (Paris, FRANCE).
https://bitbucket.org/dddouard/pygpibtoolkit -- mailto:david.douard@sdfa3.org

Helper functions and classes
"""
import re


def cmp(a, b):
    return (a > b) - (a < b)


def str_num_key(s1):
    """string comparator function that will allow to put 'toto_10' after 'toto_2'
    Also works for strings like 'toto_1_et_23er25'.
    """
    r = re.compile(r'((?<=\d)\D+|(?<=\D)\d+)')
    return [not x.isdigit() and x or int(x) for x in r.split(s1) if x]


class AbstractRegister:
    _instance = None
    _registered_type = None

    def __new__(cls):
        # implements a singleton
        if cls._instance is None:
            # debug('Instanciating %s', cls.__name__)
            cls._instance = super(AbstractRegister, cls).__new__(cls)
            cls._instance.registered = {}
            cls._instance.accepts = set()
        return cls._instance

    def add(self, cls):
        assert issubclass(cls, self._registered_type)
        if cls is self._registered_type:
            return
        if cls._accepts is None:
            return
        # assert isinstance(cls._accepts, (basestring, tuple))

        # debug("Registerered %s for %s", cls.__name__)
        if not isinstance(cls._accepts, tuple):
            cls._accepts = (cls._accepts,)
        for key in cls._accepts:
            print('Accept ', key, cls)
            key = self._get_typ(key)
            # debug("  new key = %s", key)
            self.registered.setdefault(key, []).append(cls)
            self.accepts.add(key)

    def _get_typ(self, typ):
        if not isinstance(typ, str):
            if not isinstance(typ, type):
                return None
            typ = typ.__name__
        return typ

    def __contains__(self, val):
        val = self._get_typ(val)
        return val in self.accepts

    def get_class(self, typ):
        item = typ
        if not isinstance(typ, type):
            typ = typ.__class__
        name = typ.__name__
        # debug("Looking a widget for %s", typ.__name__)
        orig_typ = typ
        while typ is not None:
            if typ.__name__ in self.registered:
                for w in self.registered[typ.__name__]:
                    if w._filter is None or w._filter(item):
                        # debug("Widget for %s is %s", typ.__name__, w)
                        return w  # self.registered[typ.__name__]
            if typ.__bases__:
                typ = typ.__bases__[0]
                if typ == object:
                    typ = None
                elif typ.__name__ in ("ObjectItem_", "AbstractListItem_"):
                    typ = orig_typ._type
            else:
                typ = None
        raise ValueError('No registered class for %s' % (name))
