#!/usr/bin/python
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
""" Copyright (c) 2007-2018 David Douard (Paris, FRANCE).
https://bitbucket.org/dddouard/pygpibtoolkit -- mailto:david.douard@sdfa3.org
"""
import sys
import signal
import time

from pygpibtoolkit.gpibcontroller import GPIBController
from pygpibtoolkit.prologix import GPIB


def main():
    import argparse
    opt = argparse.ArgumentParser(
        "A simple tool for detecting connected GPIB devices")
    opt.add_argument(
        '-d', '--device', default="/dev/ttyUSB0",
        dest="device",
        help="Device of connected Prologix GPIB bundle [/dev/ttyUSB0]",)
    opt.add_argument('-v', '--verbose', action='store_true', default=False)
    options = opt.parse_args()

    print("Detecting GPIB devices on the bus. Please wait until completion.")
    cnx = GPIB(device=options.device)
    c = GPIBController(cnx)

    signal.signal(signal.SIGINT, c.stop)
    signal.signal(signal.SIGQUIT, c.stop)

    time.sleep(1)
    devices = c.detect_devices()
    c.stop()

    print("GPIB devices:")
    for k in sorted(devices.keys()):
        print("%-3d: %s" % (k, devices[k]))
    return c, devices


if __name__ == "__main__":
    main()
