# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
""" Copyright (c) 2007-2008 David Douard (Paris, FRANCE).
https://bitbucket.org/dddouard/pygpibtoolkit -- mailto:david.douard@sdfa3.org
"""

import glob
import os
import time
import random

class GPIBplotter:#(GPIB):
    """
    A mockup thet will find in a directory some HPGL files and feed them randomly
    """
    def __init__(self, device="/dev/ttyUSB0", baudrate=115200, timeout=0.1,
                 address=5):
        self._timeout = timeout
        self.filenames = glob.glob('examples/hpgl_plots/*.plt')
        self._next = random.randint(10,50)
        self._num = 0

    def plotStarted(self):
        pass
        
    def load_plot(self, wait_timeout=0):
        if wait_timeout:
            time.sleep(wait_timeout)
        self._num += 1
        if self._num > self._next:
            ret = open(random.choice(self.filenames)).read()
            if len(ret)>0:
                self.plotStarted()
                self._num = 0
                self._next = random.randint(10,100)
                time.sleep(random.randint(1,3))
                return ret
            return None
        return None
    
        
