# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""Copyright (c) 2007-2018 David Douard (Paris, FRANCE).
https://bitbucket.org/dddouard/pygpibtoolkit -- mailto:david.douard@sdfa3.org

"""

import glob
import time
import random


class HP3562dumper:
    """A mockup that will find in a directory some HPGL files and feed them
    randomly

    """
    def __init__(self, device="/dev/ttyUSB0", baudrate=115200, timeout=0.1,
                 address=5):
        self._timeout = timeout
        self.filenames = {}
        self.filenames['state'] = glob.glob('examples/datablocks/state*.bin')
        self.filenames['trace'] = glob.glob('examples/datablocks/trace*.bin')
        self.filenames['coord'] = glob.glob('examples/datablocks/coord*.bin')

    def dump(self, mode='trace', format="binary"):
        fn = random.choice(self.filenames[mode])
        with open(fn, 'rb') as f:
            ret = f.read()
        if len(ret) > 0:
            time.sleep(random.randint(1, 3))
            return ret
        return None

    def send_command(self, *args):
        pass
