#!/usr/bin/python
import sys
import os
import signal
import time
import optparse

try:
    from pygpibtoolkit.gpibcontroller import GPIBController, deviceRegister
except ImportError:
    sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), ".."))
    from pygpibtoolkit.gpibcontroller import GPIBController, deviceRegister

import pygpibtoolkit.HP3562A
import pygpibtoolkit.HP3456

from pygpibtoolkit.prologix import GPIB

opt = optparse.OptionParser("A simple tool for detecting connected GPIB devices")
opt.add_option('-d', '--device', default="/dev/ttyUSB0",
               dest="device",
               help="Device of connected Prologix GPIB bundle [/dev/ttyUSB0]",)
options, argv = opt.parse_args(sys.argv)


cnx = GPIB(device=options.device)
c = GPIBController(cnx)

m = c.register_device(24, "HP3456A")

def cb(val):
    print val
    
m.register_data_cb(cb)
m.send_command('SM004')
m.send_command('T1SO1')

try:
    while True:
        time.sleep(0.1)
except KeyboardInterrupt:
    pass

m.send_command('SO0')
c.stop()
