# -*- coding: utf-8 -*-
"""
Constants used for HP3562A data block interpretation.
"""

EDSP = {0: "No data",
        1: "Frequency response",
        2: "Power spectrum 1",
        3: "Power spectrum 2",
        4: "Coherence",
        5: "Cross spectrum",
        6: "Input time 1",
        7: "Input time 2",
        8: "Input linear spectrum 1",
        9: "Input linear spectrum 2",
        10: "Impulse response",
        11: "Cross correlation",
        12: "Auto correlation 1",
        13: "Auto correlation 2",
        14: "Histogram 1",
        15: "Histogram 2",
        16: "Cumulative density function 1",
        17: "Cumulative density function 2",
        18: "Probability density function 1",
        19: "Probability density function 2",
        20: "Average linear spectrum 1",
        21: "Average linear spectrum 2",
        22: "Average time record 1",
        23: "Average time record 2",
        24: "Synthesis pole-zeros",
        25: "Synthesis pole-residue",
        26: "Synthesis polynomial",
        27: "Synthesis constant",
        28: "Windowed time record 1",
        29: "Windowed time record 2",
        30: "Windowed linear spectrum 1",
        31: "Windowed linear spectrum 2",
        32: "Filtered time record 1",
        33: "Filtered time record 2",
        34: "Filtered linear spectrum 1",
        35: "Filtered linear spectrum 2",
        36: "Time capture buffer",
        37: "Captured linear spectrum",
        38: "Captured time record",
        39: "Throughput time record 1",
        40: "Throughput time record 2",
        41: "Curve fit",
        42: "Weighted function",
        43: "Not used",
        44: "Orbits",
        45: "Demodulation polar",
        46: "Preview demod record 1",
        47: "Preview demod record 2",
        48: "Preview demod linear spectrum 1",
        49: "Preview demod linear spectrum 2",
        }

ECH = {0: "Channel 1",
       1: "Channel 2",
       2: "Channel 1&2",
       3: "No channel",
       }

EOVR = ECH

EDOM = {0: 'Time',
        1: 'Frequency',
        2: 'Voltage (amplitude)',
        }

EVLT = {0: "Peak",
        1: "RMS",
        2: "Volt (indicates peak only)",
        }

EAMP = {0: u"Volts",
        1: u"Volts²",
        2: u"PSD (V²/Hz)",
        3: u"ESD (V²s/Hz)",
        4: u"PSD¹² (V/Hz¹²)",
        5: u"No unit",
        6: u"Unit volts",
        7: u"Unit volts²",
        }
        
EXAXIS= {0: u"No units",
         1: u"Hertz",
         2: u"RPM",
         3: u"Orders",
         4: u"Seconds",
         5: u"Revs",
         6: u"Degrees",
         7: u"dB",
         8: u"dBV",
         9: u"Volts",
         10: u"V\u221AHz",
         11: u"Hz/s",
         12: u"V/EU",
         13: u"Vrms",
         14: u"V²/Hz",
         15: u"%",
         16: u"Points",
         17: u"Records",
         18: u"Ohms",
         19: u"Hertz/octave",
         20: u"Pulse/Rev",
         21: u"Decades",
         22: u"Minutes",
         23: u"V²s/Hz",
         24: u"Octave",
         25: u"Seconds/Decade",
         26: u"Seconds/Octave",
         27: u"Hz/Point",
         28: u"Points/Sweep",
         29: u"Points/Decade",
         30: u"Points/Octave",
         31: u"V/Vrms",
         32: u"V²",
         33: u"EU referenced to chan 1",
         34: u"EU referenced to chan 2",
         35: u"EU value",
         }

EMEAS = {0: "Linear resolution",
         1: "Log resolution",
         2: "Swept sine",
         3: "Time capture",
         4: "Linear resolution throughput",
         }

EDEMOD = {45: "AM",
          46: "FM",
          47: "PM",
          }

EAVG = {0: "No data",
        1: "Not averaged",
        2: "Averaged",}

EWIN = {0: "N/A",
        1: "Hann",
        2: "Flat top",
        3: "Uniforme",
        4: "Exponential",
        5: "Force",
        6: "Force chan 1/expon chan 2",
        7: "Expon chan 1/force chan 2",
        8: "User",
        }

EMTYP = {0: "Frequency responce",
         1: "Cross correlation",
         2: "Power spectrum",
         3: "Auto correlation",
         4: "Histogram",
         5: "No measurement",
         }

EWINTYP = { 11: "Hanning",
            12: "Flat top",
            13: "Uniform",
            14: "User window",
            15: "Force/Exponential",
            }

EFEXPW = { 0: "Force",
           1: "Exponential",
           }

EAVGTYP = { 6: "Stable",
            7: "Exponential",
            8: "Peak",
            9: "Continuous peak",
            10: "Averaging off",
            }

ETRGTYP = { 18: "Free run",
            19: "Channel 1",
            20: "Channel 2",
            21: "External",
            22: "Source trigger",
            23: "HP-IB trigger",
            }

ETRGSLP = { 16: "Positive",
            17: "Negative",
            }

EPRVTYP = { 0: "Manual preview",
            1: "Timed preview",
            2: "Preview off",
            }

ESMPTYP = { 24: "Internal sample",
            25: "External sample",
            }

ERNGUNT = EXAXIS

ERNGTYP = { 26: "Auto range on",
            27: "Auto range off",
            28: "Auto range set",
            }

EINCPL = { 29: "AC",
           30: "DC",
           }

ESRCTYP = { 31: "Source off",
            32: "Random noise",
            33: "Burst random",
            34: "Periodic chirp",
            35: "Burst chirp",
            36: "Swept sine",
            37: "Fixed sine",
            }

ESWPDIR = { 41: "Up",
            42: "Sweep hold",
            43: "Manual sweep",
            44: "Down",
            }

ESWPMOD = { 39: "Linear sweep",
            40: "Log sweep",
            }

EEXTSMPFREQUNT = EXAXIS

EBNDUNT = EXAXIS

ESWPRATEUNT = EXAXIS

EAUGAINREFCH = { 0: "Channel 1",
                 1: "Channel 2",
                 2: "Not used",
                 3: "No channel",
                 }
EDEMODCH = {  0: "Channel 1",
              1: "Channel 2",
              2: "Both channels",
              3: "No channel",
              }

ESRCLVLUNT = EXAXIS

ESRCDCOFFST = EXAXIS

ETRGLVLUNT = EXAXIS

ECPTLGHUNT = EXAXIS

EYCOORD = { 1: "Real",
            2: "Imaginary",
            3: "Linear magnitude",
            4: "Log magnitude",
            5: "dB",
            6: "Nyquist",
            7: "Not used",
            8: "Phase",
            9: "Nichols",
            10: "dBm",
            }

EDISPSMP = { 0: "Not sampled", # #displayed elements = total elements
             1: "Half sampled", # #displayed elements = total elements/2
             2: "Sampled", # #displayed elements < total elements
            }
ESCAL = { 0: "X and Y auto scale",
          1: "X fixed, Y auto scale",
          2: "X auto scale, Y fixed",
          3: "X and Y fixed",
          }
