#ifndef DISPLAY_H
#define DISPLAY_H

#include "Terminal6x8.h"
#include "Mono19x27.h"
#include "Mono15x22.h"
#include "Arial12x12.h"
#include "SSD1322.h"
#include "hp34comm.h"

typedef struct _DSP
{
	uint8_t cmd;
	uint8_t color;
	uint8_t bgcolor;
	uint8_t x0;
	uint8_t y0;
	uint8_t fmt; // 0x01=>ascii, 0x02=>hex, 0x04=>bits, 0x08=>flags, 0x80=>ignore
	uint8_t maxsize;
	uint8_t width;
	const unsigned char* font;
	char buffer[MAX_BUFF+1];
} DSP;

static DSP table[] =
{
		{ 0x00, 0xF, 0x0,  0,  0, 0x01, MAX_BUFF, 245, Mono19x27}, // main display
		{ 0x0C, 0xF, 0x0,196, 34, 0x01, 3,        45,  Mono15x22}, // channels display
		{ 0x0A, 0xF, 0x0,  0, 57, 0x08, 4,        0, Terminal6x8}, // flags + bits
};

// 9x10
const unsigned char icon_alarm[] __attribute__((aligned (2))) =
{
		0x1c, 0x0,
		0x3e, 0x0,
		0x7f, 0x0,
		0x7f, 0x0,
		0x7f, 0x0,
		0x7f, 0x0,
		0x7f, 0x0,
		0x7f, 0x0,
		0xff, 0x80,
		0x10, 0x0
};

const unsigned char icon_curve[] __attribute__((aligned (2))) =
{
		0x80, 0x0,
		0x80, 0x0,
		0x80, 0x80,
		0x81, 0x0,
		0x9e, 0x0,
		0xa0, 0x0,
		0xc0, 0x0,
		0x80, 0x0,
		0x80, 0x0,
		0xff, 0x80
};

typedef struct _FLAG
{
	uint8_t flag;
	uint8_t x;
	uint8_t y;
	bool reverse;
	const char* msg;
	const unsigned char* icon;
} FLAG;

typedef struct _FRAME
{
	uint16_t flag;
	uint8_t x0;
	uint8_t y0;
	uint8_t x1;
	uint8_t y1;
} FRAME;

static const FLAG flags[] =
{
    // flag, zone, x0, y0, reverse, msg, icon
    // right-side icons area
		{ 0x00, 246, 0,  false, NULL, icon_alarm}, // F1.0
    { 0x01, 246, 11, false, NULL, icon_curve}, // F1.1

    // F1.2 == Channel frame
    { 0x03, 197, 27, false, "Channel"},  // F1.3
    // F1.7 == Alarm frame

    { 0x34, 0,  28+8,  false, "MON"},    // F4.4
    { 0x33, 0,  28+16, false, "VIEW"},   // F4.3
    { 0x35, 0,  28,    true, "SCAN"},   // F4.5
    { 0x36, 0,  28+25, true, "CONFIG"},    // F4.6

    { 0x32, 40, 52,    false, "*"},      // F4.2
    { 0x31, 50, 52,    false, "ADRS"},   // F4.1
    { 0x30, 80, 52,    false, "RMT"},    // F4.0
    { 0x27, 104, 52,   true, "ERROR"},    // F3.7

    { 0x26, 140, 52,   false, "EXT"},    // F3.6
    { 0x25, 164, 52,   false, "ONCE"},   // F3.5

    { 0x23, 104, 28+16, false, "MEM"},    // F3.3


    // col 5
    { 0x14, 244, 22,  false, "4W"},     // F2.4
    { 0x15, 244, 30,  false, "OC"},     // F2.5
    { 0x22, 129, 28+16, false, "LAST"},   // F3.2
    { 0x21, 129, 28+16, false, "MIN"},    // F3.1
    { 0x20, 129, 28+16, false, "MAX"},    // F3.0
    { 0x17, 129, 28+16, false, "AVG"},    // F2.7

    { 0x05, 154+0,  17+10, false, "Alarm"},  // F1.5
    { 0x06, 154+0,  17+20, false, "H"},      // F1.6
    { 0x13, 154+6,  17+20, false, "1"},      // F2.3
    { 0x10, 154+12, 17+20, false, "2"},      // F2.0
    { 0x12, 154+18, 17+20, false, "3"},      // F2.2
    { 0x11, 154+24, 17+20, false, "4"},      // F2.1
    { 0x04, 154+30, 17+20, false, "L"},      // F1.4

};

static const FRAME zones[] =
{ // flag, x0, y0, x1, y1
    { 0x001, 0,   0, 245, 27}, // main display area
    { 0x002, 246, 0, 255, 27}, // right notif area
    { 0x004, 208, 35, 254, 62}, // channels display area
    { 0x008, 160, 28, 202, 54}, // alarms area
    { 0x010, 0,   28, 32,  54}, // flags col1
    { 0x020, 33,  28, 70,  54}, // flags col2
    { 0x040, 71,  28, 103, 54}, // flags col3
    { 0x080, 104, 28, 128, 54}, // flags col4
    { 0x100, 129, 28, 159, 54}, // flags col5

//    { 0x8000, 0, 55, 255, 63}, // flags bits display area
};

static const FRAME frames[] =
{
    { 0x02, 194, 30, 243, 53}, // F1.2 - channel frame
    { 0x07, 151, 30, 192, 46}, // F1.7 - alarm frame
};


class Display: public SSD1322
{
public:
	Display(int Hz, PinName mosi, PinName miso, PinName sclk, PinName CS, PinName reset, PinName DC,
					const char* name);

	virtual ~Display();

	void test_dsp();
	void show(uint8_t, const char*, uint8_t);
	void show_splashscreen();

private:
	uint8_t must_refresh;

};

#endif
