#ifndef DISPLAY_H
#define DISPLAY_H

#include "Terminal6x8.h"
#include "Mono19x27.h"
#include "Mono15x22.h"
#include "Arial12x12.h"
#include "SSD1322.h"
#include "hp34comm.h"

#include <map>

//typedef enum {
#define FMT_ASCII  0x01
#define FMT_HEX    0x02
#define FMT_BITS   0x04
#define FMT_FLAGS  0x08
#define FMT_IGNORE 0x80
	//} dsp_format_t;


typedef struct _DSP
{
	uint8_t cmd;
	uint8_t color;
	uint8_t bgcolor;
	uint8_t x0;
	uint8_t y0;
	uint8_t fmt; // 0x01=>ascii, 0x02=>hex, 0x04=>bits, 0x08=>flags, 0x80=>ignore
	uint8_t maxsize;
	uint8_t width;
	const unsigned char* font;
	char buffer[MAX_BUFF+1];
} DSP;


typedef struct _FLAG
{
	uint8_t x0;
	uint8_t y0;
	uint8_t x1;
	uint8_t y1;
	bool reverse;
	const char* msg;
	const unsigned char* icon;
} FLAG;

typedef std::map<uint8_t, FLAG> flags_map;
typedef std::map<uint8_t, bool> flag_status_map;

class Display: public SSD1322
{
public:
	Display(int Hz, PinName mosi, PinName miso, PinName sclk, PinName CS, PinName reset, PinName DC,
			const char* name);

	virtual ~Display();

	void show(uint8_t, const char*, uint8_t);
	void dim_char(uint8_t);
	void show_splashscreen();
	void show_byescreen();

	void set_flag_status(uint8_t flagid, bool show);
	void set_flag_dim(uint8_t flagid, bool dim);

	void draw_flag(uint8_t flagid);

private:
	uint8_t must_refresh;
	flag_status_map flags_status;
	flag_status_map flags_dim;

};

#endif
