#ifndef KEYPAD_H
#define KEYPAD_H

#include "mbed.h"
//#include "rtos.h"
#include <vector>


typedef Callback<void(uint8_t, uint8_t)> keyevent_callback_t;

class Keypad {
public:
  Keypad(uint8_t nRows, DigitalIn rows[],
	 uint8_t nColumns, DigitalOut cols[],
	 int debounce_ms=20);

  /** Destructor
   */
  ~Keypad();

  void attach(const keyevent_callback_t& kp_callback=NULL,
	      const keyevent_callback_t& kr_callback=NULL);

  void start(void);
  void stop(void);


protected:
  std::vector<DigitalIn> _rows;
  std::vector<DigitalOut> _columns;
  int              _debounce;  // miliseconds

  void _kp();
  void _kr();
  void _keyPressed(int row);
  void _keyReleased(int row);
  void run();

private:
  keyevent_callback_t _kp_callback;
  keyevent_callback_t _kr_callback;
  bool _started;
  Thread _loop;
  //tloop.start(&loop);
  uint8_t _nrows;
  uint8_t _ncols;
  uint8_t *_keys;
};


#endif // KEYPAD_H
