#include "stdio.h"
#include "mbed.h"
#include "string"
#include "Arial12x12.h"
#include "Arial28x28.h"
//#include "Arial24x23.h"
//#include "Terminal6x8.h"
//#include "Arial43x48_numb.h"

#include "BufferedSerial.h"

#include "SPI8.h"
#include "ILI9341.h"

//Serial pc(USBTX, USBRX);
BufferedSerial hp(NC, PA_1, 64, 0); // serial4

ILI9341 tft(SPI_8, 24000000, PA_7, PA_6, PA_5, PA_4, PB_6, PC_7, "myLCD"); // Spi 8bit, 24MHz, mosi, miso, sclk, cs, reset, dc
//ILI9341 tft(SPI_8, 24000000, PA_7, PA_6, PA_5, PA_4, PB_6, PB_5, "myLCD");

#define MAX_BUFF 16
uint8_t curchar;
uint8_t cmd;
uint8_t nchars;
char buffer[MAX_BUFF+1];

typedef struct _DSP
{
  uint8_t cmd;
  uint16_t color;
  uint16_t bgcolor;
  uint8_t y0;
  uint8_t fmt; // 0=>ascii, 1=>hex, 2=>bits, 3=>flags
  uint8_t maxsize;
  const unsigned char* font;
  char buffer[MAX_BUFF+1];
} DSP;

static DSP table[] =
{
  { 0x00, Blue,   Black,  5,    0, MAX_BUFF, Arial28x28},
  { 0x0C, Blue,   Black,  40,   0, 3,        Arial28x28},
  { 0x01, Green,  Black,  95,   1, MAX_BUFF, Arial12x12},
  { 0x02, Green,  Black,  110,  1, MAX_BUFF, Arial12x12},
  { 0x0A, Blue,   Yellow, 145,  2, 4,        Arial12x12},
  { 0x0A, Yellow, Black,  70 ,  3, 4,        Arial12x12},
  { 0xFF, Red,    Black,  210,  0, MAX_BUFF, Arial12x12},
};

typedef struct _FLAG
{
  uint8_t flag;
  uint8_t x;
  uint8_t y;
  const char* msg;
} FLAG;

static const FLAG flags[] =
  {
    { 0x00, 0,   70, "Alarm"},  // F1.1
    { 0x01, 40,  70, "Mx+B"},   // F1.2
    { 0x03, 40,  70, "Channels"},   // F1.4
    { 0x14, 70,  70, "4W"}, // F2.5
    { 0x33, 90,  70, "VIEW"},
    { 0x34, 120, 70, "MON"},
    { 0x36, 150, 70, "CONFIG"},
  };
#define DEBUG
#ifdef DEBUG
#define DBGPIN PC_0

DigitalOut dbgpin(DBGPIN);
inline void DebugPulse(uint8_t count=1)
{
  while (count--)
  {
    dbgpin = 1;
    dbgpin = 0;
  }
}
#else
inline void DebugPulse(uint8_t count=1)
{}
#endif

void setup() {
    // init the LCD

    tft.set_orientation(3);
    //pc.baud (115200);
    //pc.printf("\n\nSystem Core Clock = %.3f MHZ\r\n",
    //      (float)SystemCoreClock/1000000);

    hp.baud(187500);

    // myLCD.set_font((unsigned char*) Terminal6x8);
    // myLCD.claim(stdout);      // send stdout to the LCD display
    // myLCD.claim(stderr);      // send stderr to the LCD display
    tft.background(Black);    // set background to black
    tft.cls();

    cmd = 0xFF;
    curchar = 0;
    nchars = 0;
}

void go_msg() {
  tft.set_font((unsigned char*) Arial12x12);
  tft.locate(0, 210);
}

void show(uint8_t cmd, char *txt, uint8_t nchar=0) {
  uint8_t i, len;
  uint16_t bgcolor, fgcolor;
  char *oldv;

  len = MAX_BUFF;

  for (i=0; i<sizeof(table)/sizeof(table[0]); ++i) {
    if (table[i].cmd == cmd) {
      bgcolor = table[i].bgcolor;
      fgcolor = table[i].color;
      tft.background(bgcolor);
      tft.foreground(fgcolor);
      tft.locate(0, table[i].y0);
      tft.set_font((unsigned char*) table[i].font);
      oldv = table[i].buffer;
      
      switch (table[i].fmt) {
      case 0: //ascii
	tft.printf(txt);
	for (uint8_t j=strlen(txt); j<table[i].maxsize; j++)
	  tft.printf(" ");
	break;
      case 1: // hex
	for (uint8_t j=0;; j++) {
	  if (txt[j] == 0x00)
	    break;
	  tft.printf("%02X ", txt[j]);
	}
	for (uint8_t j=3*strlen(txt); j<table[i].maxsize; j++)
	  tft.printf(" ");
	break;
      case 2: // binary
	tft.foreground(fgcolor);
	tft.printf(" [");
	for (uint8_t j=0; j<max(nchar, table[i].maxsize) ; j++) {
	  if (j>0) {
	    tft.foreground(fgcolor);
	    tft.printf(" | ");
	  }
	  for (uint8_t k=0; k<8; k++) {
	    if (txt[j] & (1 << (7-k)))
	      tft.foreground(fgcolor);
	    else
	      tft.foreground(bgcolor);
	    tft.printf("%d", (8-k));
	  }
	}
	tft.foreground(fgcolor);
	tft.printf("]");
	break;
      case 3: // flags
	for (uint8_t j=0; j<max(nchar, table[i].maxsize) ; j++) {
	  for (uint8_t k=0; k<8; k++) {
	    if ((txt[j] & (1 << k) ) != (oldv[j] & (1 << k))) {
	 
	      if (txt[j] & (1 << k))
		tft.foreground(fgcolor);
	      else
		tft.foreground(bgcolor);
	      for (uint8_t l=0;
		   l<(sizeof(flags)/sizeof(flags[0])); ++l) {
		if (flags[l].flag == ((j<<4) + k)) {
		  tft.locate(flags[l].x, flags[l].y);
		  tft.printf(flags[l].msg);
		  break;
		}
	      }
	    }
	  }
	  oldv[j] = txt[j];
	}
	break;
      }

    }
  }

}


void loop() { // run over and over
  if (hp.readable()) {
      uint8_t val = hp.getc();
      DebugPulse(3);
      // 0xFF: idle
      // 0xFE: frame finished
      // 0x66: Start of transmission received
      if (cmd == 0xFF) {
          if ((val == 0x66) || (val == 0x99)) {
              cmd = val;
          } else if ((val == 0x00) || (val == 0x55)){
              // probably an ACK for a keypad related event
          } else {
              // display "junk" byte
              //DebugPulse();
              show(0xFF, "", 0);
	      tft.printf("%02X:> %02x", cmd, val);
          }

      } else if (cmd == 0xFE ) {
          if ((val == 0x66) || (val == 0x99)) {
              cmd = val;
          } else if (val == 0x55) {
              cmd = 0xFF;
          } else if (val == 0x00){
              // probably an ACK for a keypad related event
          } else {
              // display "junk" byte
              DebugPulse();
              show(0xFF, "", 5);
              tft.printf("%02X=> %02x", cmd, val);
          }

      } else if (cmd == 0x66) { // waiting for the display command
	if ((val == 0x0C) || (val == 0x00) || (val == 0x01) || (val == 0x02) || (val == 0x0A)) {
              cmd = val;
              nchars = 0;
          } else {
              cmd = 0xFE;
              // display unknown cmd byte
              DebugPulse();
              show(0xFF, "", 10);
              tft.printf("%02X-> %02x", cmd, val);
          }

      } else if (cmd == 0x99) { // waiting for a 0x00, it's the DP that sent a keypress event
        if (val != 0x00) {
              show(0xFF, "", 0);
	      tft.printf("%02X kp %02X", cmd, val);
        }
        cmd = 0xFF;

      } else if (nchars == 0) { // waiting for the number of chars to display
          if (val>MAX_BUFF) {
              // display warning
              //dsp();
              //tft << cmd << " got len " << val;
              //DebugPulse();
              show(0xFF, "", 0);
	      tft.printf("%02X len %d", cmd, val);
              cmd = 0xFE; // weird
          } else {
              nchars = val;
              curchar = 0;
          }

      } else { // a character to display
          buffer[curchar] = val;
          curchar++;
          if (curchar == nchars) {
              buffer[curchar] = 0x00;
              show(cmd, buffer, nchars);
              nchars = 0;
              curchar = 0;
              cmd = 0xFE;
          }
      }

      DebugPulse(4);
      
  }
}

int main()
{
  setup();
  while(1)
    loop();
}
