// STM32F303xE based HP34970 replacement PCB

#if !defined(DEF_HP34970_FP_H)

#define DEF_HP34970_FP_H

#define DSP_MOSI PA_7
#define DSP_MISO PA_6 // NC
#define DSP_SCLK PA_5
#define DSP_CS   PA_2
#define DSP_RST  PA_3
#define DSP_DC   PA_4

// UART for RX (CPU->DP)
#define HP_RX PC_5
#define HP_TX PC_4

// RST pin (handle this by hand)
#define HP_RST PA_15

// encoder
#define KP_ENC1 PA_0
#define KP_ENC2 PA_1

// keypad
#define KP_R0 PB_5
#define KP_R1 PB_6
#define KP_R2 PB_7
#define KP_R3 PB_8

#define KP_C0 PC_2
#define KP_C1 PC_1
#define KP_C2 PC_0
#define KP_C3 PB_4
#define KP_C4 PB_0

#if defined(HAVE_PC)

#include <USBSerial.h>
#if 1
USBSerial pc(false);  // PA_11 USB_DM, PA_12 USB_DP (with 1.5k pull-up)
#else
BufferedSerial pc(PC_10_ALT0, PC_11_ALT0, 115200); // UART_4
#endif

#endif

#endif
