import zipfile
import configparser


def extract_metadata(fname):
    cfg = configparser.ConfigParser()
    with zipfile.ZipFile(fname) as zf:
        mdata = zf.open('metadata').read()
    cfg.read_string(mdata.decode())
    return cfg


def print_metadata(mdata):
    for kv in mdata['global'].items():
        print('%s: %s' % kv)
    for device, cfg in mdata.items():
        if device in ('global', 'DEFAULT'):
            continue
        print('%s:' % device)
        for kv in cfg.items():
            print('  %s: %s' % kv)


if __name__ == '__main__':
    import sys
    for fn in sys.argv[1:]:
        print_metadata(extract_metadata(fn))
