#include "stdio.h"
#include "mbed.h"
#include "string"
#include "Arial12x12.h"
#include "Arial28x28.h"
//#include "Arial24x23.h"
//#include "Terminal6x8.h"
//#include "Arial43x48_numb.h"

#include "BufferedSerial.h"

#include "SPI8.h"
#include "ILI9341.h"

Serial pc(USBTX, USBRX);
BufferedSerial hp(PA_0, PA_1, 32); // serial4

ILI9341 tft(SPI_8, 24000000, PA_7, PA_6, PA_5, PA_4, PB_6, PC_7, "myLCD"); // Spi 8bit, 24MHz, mosi, miso, sclk, cs, reset, dc
//ILI9341 tft(SPI_8, 24000000, PA_7, PA_6, PA_5, PA_4, PB_6, PB_5, "myLCD");

#define MAX_BUFF 13
uint8_t curchar;
uint8_t cmd;
uint8_t nchars;
char buffer[MAX_BUFF+1];

typedef struct _DSP
{
  uint8_t cmd;
  uint16_t color;
  uint16_t bgcolor;
  uint8_t y0;
  uint8_t fmt; // 0=>ascii, 1=>hex, 2=>bits
  uint8_t maxsize;
  const unsigned char* font;
  char buffer[MAX_BUFF+1];
} DSP;

static DSP table[] =
{
  { 0x00, Yellow, Red,    5,    0, MAX_BUFF, Arial28x28},
  { 0x0C, Red,    Blue,   40,   0, 3,        Arial28x28},
  { 0x01, Blue,   Yellow, 75,   1, MAX_BUFF, Arial12x12},
  { 0x02, Blue,   Yellow, 110,  1, MAX_BUFF, Arial12x12},
  { 0x0A, Blue,   Yellow, 145,  2, 4,        Arial12x12},
  { 0xFF, Red,    Black,  210,  0, MAX_BUFF, Arial12x12},
};
#define DEBUG
#ifdef DEBUG
#define DBGPIN PC_0

DigitalOut dbgpin(DBGPIN);
inline void DebugPulse(uint8_t count=1)
{
  while (count--)
  {
    dbgpin = 1;
    dbgpin = 0;
  }
}
#else
inline void DebugPulse(uint8_t count=1)
{}
#endif

void setup() {
    // init the LCD

    tft.set_orientation(3);
    pc.baud (115200);
    pc.printf("\n\nSystem Core Clock = %.3f MHZ\r\n",
	      (float)SystemCoreClock/1000000);

    hp.baud(187500);

    // myLCD.set_font((unsigned char*) Terminal6x8);
    // myLCD.claim(stdout);      // send stdout to the LCD display
    // myLCD.claim(stderr);      // send stderr to the LCD display
    tft.background(Black);    // set background to black
    tft.cls();

    cmd = 0xFF;
    curchar = 0;
    nchars = 0;
}

void go_msg() {
  tft.set_font((unsigned char*) Arial12x12);
  tft.locate(0, 210);
}

void show(uint8_t cmd, char *txt, uint8_t nchar=0) {
  uint8_t i, len;
  uint16_t bgcolor, fgcolor;
  char *oldv;

  len = MAX_BUFF;

  for (i=0; i<sizeof(table)/sizeof(table[0]); ++i) {
    if (table[i].cmd == cmd) {
      bgcolor = table[i].bgcolor;
      fgcolor = table[i].color;
      tft.background(bgcolor);
      tft.foreground(fgcolor);
      tft.locate(0, table[i].y0);
      tft.set_font((unsigned char*) table[i].font);
      break;
    }
  }

  switch (table[i].fmt) {
  case 0: //ascii
    tft.printf(txt);
    for (uint8_t j=nchar; j<table[i].maxsize; j++)
      tft.printf(" ");
    break;
  case 1: // hex
    for (uint8_t j=0; j<nchar; j++)
      tft.printf("%02X ", txt[j]);
    for (uint8_t j=nchar; j<table[i].maxsize; j++)
      tft.printf(" ");
    break;
  case 2: // binary
    for (uint8_t j=0; j<max(nchar, table[i].maxsize) ; j++) {
      //tft.setCursor(x0+w*i, y0+10);
      for (uint8_t k=0; k<8; k++) {
	if (txt[j] & (1 << (7-k)))
	  tft.foreground(fgcolor);
	else
	  tft.foreground(bgcolor);
	tft.printf("%d", (8-k));
      }
    }
    break;
  }
}


void loop() { // run over and over
  if (hp.readable()) {
      uint8_t val = hp.getc();
      DebugPulse();
      // 0xFF: idle
      // 0xFE: frame finished
      // 0x66: Start of transmission received
      if (cmd == 0xFF) {
          if ((val == 0x66) || (val == 0x99)) {
              cmd = val;
          } else if ((val == 0x00) || (val == 0x55)){
              // probably an ACK for a keypad related event
          } else {
              // display "junk" byte
              //DebugPulse();
              go_msg();
              tft.printf("%02X:> %02x", cmd, val);
          }

      } else if (cmd == 0xFE ) {
          if ((val == 0x66) || (val == 0x99)) {
              cmd = val;
          } else if (val == 0x55) {
              cmd = 0xFF;
          } else if (val == 0x00){
              // probably an ACK for a keypad related event
          } else {
              // display "junk" byte
              //DebugPulse();
              go_msg();
              tft.printf("%02X=> %02x", cmd, val);
          }

      } else if (cmd == 0x66) { // waiting for the display command
          if ((val == 0x0C) || (val == 0x00) || val == 0x01 || val == 0x02 || val == 0x0A) {
              cmd = val;
              nchars = 0;
          } else {
              cmd = 0xFE;
              // display unknown cmd byte
              //DebugPulse();
              go_msg();
              tft.printf("%02X-> %02x", cmd, val);
          }

      } else if (cmd == 0x99) { // waiting for a 0x00, it's the DP that sent a keypress event
        if (val != 0x00) {
            go_msg();
	    tft.printf("%02X kp %02X", cmd, val);
        }
        cmd =0xFF;

      } else if (nchars == 0) { // waiting for the number of chars to display
          if (val>MAX_BUFF) {
              // display warning
              //dsp();
              //tft << cmd << " got len " << val;
              //DebugPulse();
              go_msg();
	      tft.printf("%02X len %d", cmd, val);
              cmd = 0xFE; // weird
          } else {
              nchars = val;
              curchar = 0;
          }

      } else { // a character to display
          buffer[curchar] = val;
          curchar++;
          if (curchar == nchars) {
              buffer[curchar] = 0x00;
              show(cmd, buffer, nchars);
              nchars = 0;
              curchar = 0;
              cmd = 0xFE;
          }
      }
  }
}

int main()
{
  setup();
  while(1)
    loop();
}
